<?php
	
	/***************************************************************
	 * cssStyleOn - http://cssStyleOn.c0n.de 2008 by Stefan Baur
	 *--------------------------------------------------------------
	 *  src/cssmanager_import_export.php
	 *     css stylesheet import and export functions
	 *--------------------------------------------------------------
	 *  TODO: allow less strict formating in css file
	 **************************************************************/


global $cssStyleOn;

	// clean up css code
function cssCleanup($css)
	{
		//sort by keys alphabetically
	ksort($css);

	foreach($css as $css_tag=>$css_style)
		{
			//replace whitespaces with one single space and multiple ;; with one ;
		$css_style=trim(preg_replace('/\s+/',' ',preg_replace('/;\s*;/',';',$css_style)));
		
		if($css_style==";")$css_style=""; //if all that was left over is a single ';' clear that too
		
		$css[$css_tag]=$css_style;
		}
		
	return $css;
	}

	/*************************************************
	 * Import / Export
	 ************************************************/

function cssExportStylesheet($css,$filename)
	{
	return @file_put_contents($filename,"/* CSS Stylesheet automatically generated by cssStyleOn 2008 by Stefan Baur (http://cssStyleOn.c0n.de/) */\n\n".cssGenerateStylesheet($css));
	}

function cssExportFCKStyles($css,$filename)
	{
	return @file_put_contents($filename,"<?xml version=\"1.0\" encoding=\"utf-8\" ?>
<!--
 * FCKeditor custom styles automatically generated by cssStyleOn 2008 by Stefan Baur (http://cssStyleOn.c0n.de/)  *
-->
<Styles>
".cssGenerateFCKStyles($css)."
</Styles>");
	}

function cssImportStylesheet($filename)
	{
	global $cssStyleOn;

	$mappingTAG2TAB=$cssStyleOn['MAPPING_TAG2TAB'];

	$matches=array();
	$ret=array();

	if(preg_match_all("/(.*) { (.*) }/i",file_get_contents($filename),$matches,PREG_SET_ORDER)!=FALSE)
		{
		foreach($matches as $m)
			{
			$m[1]=trim($m[1]);
			$syntaxcheck=explode('.',$m[1]);

				//allow no spaces or more than one '.'
			if(!isset($mappingTAG2TAB[$syntaxcheck[0]]) || (!(strpos($m[1],' ')===FALSE)))
				{
					//d'oh ... there is a cssTag in the stylesheet we do not cover here
					//FIXME: what to do?
				continue; //-> simply skip it
				}

			switch(count($syntaxcheck))
				{
				case 1:
					$ret[$m[1].".#"]=$m[2]; //default entry for tag, add a artificial # class
					break;
				case 2:
					$ret[$m[1]]=$m[2]; //good syntax in the form tag.class
					break;
				default:
					continue; //skip this malformed entry? FIXME: anything we can do here?
				}
			}
		}
	return $ret;
	}

function cssGenerateStylesheet($css)
	{
	$ret="";

	foreach($css as $css_tag=>$css_style)
		{
		$pos=strpos($css_tag,'.');
		$cssTag=substr($css_tag,0,$pos);
		$cssClass=substr($css_tag,$pos+1);
		$cssStyle=get_magic_quotes_gpc()?stripslashes($css_style):$css_style;

		if($cssClass[0]=='#')$css_tag="$cssTag"; //transform artificial default class correctly

		$ret.="$css_tag { $cssStyle }\n";
		}
	return $ret;
	}

function cssGenerateFCKStyles($css)
	{
	$ret="";

	foreach($css as $css_tag=>$css_style)
		{
		$pos=strpos($css_tag,'.');
		$cssTag=substr($css_tag,0,$pos);
		$cssClass=substr($css_tag,$pos+1);
		$cssStyle=get_magic_quotes_gpc()?stripslashes($css_style):$css_style;

		if($cssClass[0]=='#')continue; //skip artificial default classes

		$ret.="<Style name=\"$css_tag\" element=\"$cssTag\">\n	<Attribute name=\"class\" value=\"$cssClass\" />\n</Style>\n";
		}
	return $ret;
	}

?>